@extends('Frontend_1.layouts.app')
@section('content')
@include('Frontend_1.layouts.header')




<section class="blog-section bg-grey bd-bottom padding">
    <div class="container">
        <div class="section-heading text-center mb-40">
            <h2>Recent Stories</h2>
            <span class="heading-border"></span>
            <p>Help today because tomorrow you may be the one who <br> needs more helping!</p>
        </div><!-- /Section Heading -->
        <div class="row">
            <div class="col-lg-12 xs-padding">
                <div class="blog-items grid-list row">
                    @forelse($on_going_project_all as $on_going)
                    {{-- {{$on_going}} --}}
                    <div class="col-md-4 padding-15">
                        <div class="blog-post">
                            <img src="{{asset('')}}{{$on_going->image}}"
                                alt="blog post">
                            <div class="blog-content">
                                <span class="date"><i class="fa fa-clock-o"></i> {{$on_going->created_at->format('D-M-Y')}}</span>
                                <h3><a href="#">{{$on_going->title}}</a></h3>
                                <p>{{Str::words($on_going->short_description, 20, '...') }}</p>
                                <a href="{{url('single_on_going/'.$on_going->id)}}" class="post-meta">Read More</a>
                            </div>
                        </div>
                    </div><!-- Post 1 -->
                    @empty
                     Sorry No blog post
                    @endforelse

                    
                   
                   

                </div>
            </div><!-- Blog Posts -->
        </div>
    </div>
</section>

<section class="widget-section padding" style="background:#04582d;">
    <div class="container">
        <div class="widget-wrap row">
            <div class="col-md-4 xs-padding">
                <div class="widget-content">
                    <img src="https://html.dynamiclayers.net/dl/charitify/img/logo-light.png" alt="logo">
                    <p class="text-light">This Section is under construction</p>
                    <!-- <ul class="social-icon">
                                        <li><a href="#"><i class="fa fa-facebook"></i></a></li>
                                        <li><a href="#"><i class="fa fa-twitter"></i></a></li>
                                        <li><a href="#"><i class="fa fa-pinterest"></i></a></li>
                                        <li><a href="#"><i class="fa fa-instagram"></i></a></li>
                                        <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
                                    </ul> -->
                </div>
            </div>
            <div class="col-md-4 xs-padding">
                <div class="widget-content">
                    <h3>Recent Campaigns</h3>
                    <ul class="widget-link">
                        {{-- <li><a href="#">First charity activity of this summer. <span>-1 Year Ago</span></a></li>
                        <li><a href="#">Big charity: build school for poor children. <span>-2 Year Ago</span></a>
                        </li>
                        <li><a href="#">Clean-water system for rural poor. <span>-2 Year Ago</span></a></li>
                        <li><a href="#">Nepal earthqueak donation campaigns. <span>-3 Year Ago</span></a></li> --}}
                        <p class="text-light">This section is under construction</p>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 xs-padding">
                <div class="widget-content">
                    <h3>NGO Location</h3>
                    <ul class="address">
                        {{-- <li> Info@YourDomain.com</li>
                        <li> +(333) 052 39876</li>
                        <li> Www.YourWebsite.com</li>
                        <li> 60 Grand Avenue. Central New Road 0708, USA</li> --}}
                        <p class="text-light">This section is under construction</p>

                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection