@extends('Admin.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-6 col-sm-4 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3>
                        You Tube Add
                    </h3>
                    @if ($errors->any())
                        {!! implode('', $errors->all('<div class="text-danger">:message</div>')) !!}
                    @endif
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.you_tube_store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="mb-3">
                            <label for="" class="form-label">Title</label>
                            <input type="text" class="form-control" name="title">

                        </div>
                        <div class="mb-3">
                            <label for="" class="form-label">You Tube Link</label>
                            <input type="text" name="link" class="form-control">
                        </div>

                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary w-100">Insert</button>
                        </div>
                </div>
                </form>
            </div>

        </div>
    </div>
    <div class="container py-5">
        <div class="row">
            @forelse($you_tube as $you_tubes)
                <div class="col-lg-4 col-md-4 col-sm-6 mb-4">
                    <div class="card you_tube  shadow-sm" style="min-height:300px;">
                        <div class="ratio ratio-16x9" style="height:200px;">
                            <iframe class="embed-responsive-item" src="{{ $you_tubes->link }}" title="YouTube video player"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                referrerpolicy="strict-origin-when-cross-origin" style="width:100%;height:100%;" allowfullscreen>
                            </iframe>
                        </div>
                        <div class="card-body">
                            <p class="card-title">{{ $you_tubes->title }}</p>
                            <button type="button" class="edit-btn btn btn-success" data-toggle="modal" data-target="#editModal{{$you_tubes->id}}"
                                data-id="{{ $you_tubes->id }}" data-title="{{ $you_tubes->title }}"><i
                                    class="fas fa-edit"></i></button>
                                    <a href="{{route('admin.you_tube_delete',$you_tubes->id)}}" type="button" class="btn btn-danger"
                                        data-id="{{ $you_tubes->id }}" data-title="{{ $you_tubes->title }}"><i class="fas fa-trash"></i></a>
        


                        </div>
                    </div>
                </div>
                <div class="modal fade" id="editModal{{$you_tubes->id}}" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="editModalLabel">Edit Video Details</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form id="editForm" action="{{route('admin.you_tube_edit',$you_tubes->id)}}" method="POST">
                                    @csrf
                                    <input type="hidden" name="id" id="videoId">
                                    <div class="form-group">
                                        <label for="videoTitle">Title</label>
                                        <input type="text" class="form-control" id="videoTitle" name="title" value="{{ $you_tubes->title }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="" class="form-label">You Tube Link</label>
                                        <input type="text" class="form-control" name="link" value="{{$you_tubes->link}}">
                                    </div>
                                    <!-- Add more fields here if needed -->
                                    <button type="submit" class="btn btn-primary">Save changes</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <p class="text-center text-muted">No videos available</p>
                </div>
            @endforelse
        </div>
       
    </div>
    <style>
        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #333;
        }

        .you_tube {

            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
        }

        .container {
            padding-top: 20px;
        }

        .ratio {
            overflow: hidden;
        }

        .ratio iframe {
            border-radius: 0.25rem 0.25rem 0 0;
        }

        .card-body {
            background-color: #f8f9fa;
            border-top: 1px solid #e9ecef;
        }
    </style>




    <script>
        $(document).ready(function() {
            $('#summernote').summernote({
                placeholder: 'Type Here',
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#thumbnail_image').change(function(event) {
                const imagePreview = $('#thumbnail_images');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#promo_2').change(function(event) {
                const imagePreview = $('#imagePreview_promo');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#promo_3').change(function(event) {
                const imagePreview = $('#imagePreview_promo3');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#slider').change(function(event) {
                const imagePreview = $('#imagePreview_carousel');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    @if (session('success'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "success",
                title: "{{ session('success') }}"
            });
        </script>
    @endif

    @if (session('error'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "error",
                title: "{{ session('success') }}"
            });
        </script>
    @endif
@endsection
