<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('information_stores', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('name');
            $table->string('father_name');
            $table->string('mother_name');
            $table->string('gender');
            $table->string('married')->nullable();
            $table->string('spouse_name')->nullable();
            $table->string('childrean')->nullable();
            $table->string('occupation');
            $table->string('institute_name');
            $table->text('present_address');
            $table->text('permanenet_address');
            $table->string('Nid');
            $table->string('Office_id');
            $table->string('pictures');
            $table->integer('status')->nullable();
            $table->integer('short_note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void 
    {
        Schema::dropIfExists('information_stores');
    }
};
