<?php

namespace App\Http\Controllers;

use App\Models\Admin_login;
use App\Models\Information_store;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    //
    public function admin_login_page(){
        return view('Admin.admin_home');
    }
    public function admin_login_post(Request $request){
      
        if (Auth::guard('admin')->attempt([
            'email' => $request->email,
            'password' => $request->password,
        ])){
            return redirect()->route('admin.page');
        }else{
            return "sorry";
        }
    }
    public function admin_page(){
       $all_user_request =  Information_store::orderBy('updated_at','desc')->get();
        return view('Admin.admin_dashboard',[
            'all_user_request'=>$all_user_request,
        ]);
    }
    public function admin_logout(){

        Auth::guard('admin')->logout();
        return redirect()->route('admin.login_page');
      
    }
    public function req_user_details($id){
        $req_user = Information_store::find($id);
        return view('Admin.user_details',[
            'req_user'=>$req_user,
        ]);
    }
    public function accept_request($id){
        $req_user = Information_store::find($id);
        $req_user->update([
            'status'=>1
        ]);
        return back()->with('success',"Successfully Accepted");
    }
    public function not_accept_request($id){
        $req_user = Information_store::find($id);
        $req_user->delete();
        return redirect('/admin_page');
    }
    public function logout(){
        Auth::logout();
        return redirect('/')->with('success',"Successfully Logged Out");
    }
    public function admin_profile(){
        return view('Admin.admin_profile');
    }
    public function admin_update(Request $request){
        $request->validate([
            'email'=>'required',
            'password'=>'required',
        ]);
         $update = Admin_login::find(Auth::guard('admin')->user()->id)->update([
            'email'=>$request->email,
            'password'=>$request->password,
        ]);
        if($update){
            return back()->with('success',"Successfully Changed");
        }else{
            return back()->with('error',"Sorry ");
        }
    }
}
