<section class="team-section bg-grey bd-bottom circle shape padding" id="gallery">
    <div class="container">
        <div class="section-heading text-center mb-40">
            <h2>Image Gallery</h2>
            <span class="heading-border"></span>
            <p>This is the recent working project's images</p>
        </div>
        <div class="row">
            @forelse($image_gallery as $images)
            <div class=" col-lg-3 col-sm-2 mb-3">
                <div class="team-details">
                    <img src="{{asset('/')}}{{$images->image}}" alt="team" style="max-height: 100%;max-width:100%;">
                    <div class="hover">
                        <h3>{{$images->title}}</h3>
                    </div>
                </div>
            </div>
            @empty
            Sorry No Images
            @endforelse
           

           
           
        </div>
       
       
    </div>
</section>
<style>
    /* Container settings */
.container {
    max-width: 1200px; /* Adjust as needed */
    margin: 0 auto;
    padding: 20px;
}

/* Section heading styling */
.section-heading {
    margin-bottom: 40px;
}

.section-heading h2 {
    font-size: 2rem;
    margin-bottom: 10px;
}

.heading-border {
    display: block;
    width: 50px;
    height: 4px;
    background-color: #000; /* Adjust color as needed */
    margin: 10px auto;
}

.section-heading p {
    font-size: 1rem;
    color: #555; /* Adjust color as needed */
}

/* Row styling for grid */
.row {
    display: flex;
    flex-wrap: wrap;
    margin: -15px; /* Adjust for gutter spacing */
}

/* Column settings */
.col-md-3 {
    flex: 1 0 25%; /* 4 columns per row */
    padding: 15px; /* Adjust gutter spacing */
}

/* Team details styling */
.team-details {
    position: relative;
    overflow: hidden;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    background-color: #fff;
    height: 250px; /* Fixed height */
}

/* Image settings */
.team-details img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Cover ensures images fill the container */
    display: block;
}

/* Hover effect container */
.hover {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: rgba(0, 0, 0, 0.6);
    color: #fff;
    text-align: center;
    padding: 10px;
    transition: opacity 0.3s ease;
    opacity: 0; /* Hide initially */
}

/* Show hover content on hover */
.team-details:hover .hover {
    opacity: 1;
}

.hover h3 {
    margin: 0;
    font-size: 1.25rem;
}

.hover span {
    display: block;
    font-size: 0.875rem;
    font-weight: 300;
}

</style>