@extends('Admin.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-6 col-sm-4 mx-auto">
              <div class="card">
                <div class="card-header">
                    <h3>
                        On Going Project
                    </h3>
                    @if ($errors->any())
                    {!! implode('', $errors->all('<div class="text-danger">:message</div>')) !!}
                @endif
                </div>
                <div class="card-body">
                    <form action="{{route('admin.upcoming_project_edit',$upcoming_project->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="" class="form-label">Title</label>
                        <input type="text" class="form-control" name="title" value="{{$upcoming_project?$upcoming_project->title:''}}">

                    </div>
                    <div class="mb-3">
                        <label for="" class="form-label">Short Description</label>
                        <textarea name="short_description" cols="10" rows="5" class="form-control" >{{$upcoming_project?$upcoming_project->short_description :''}}</textarea>
                    </div>
                    <div class="mb-3">
                        <label for="" class="form-label">Long Description</label>
                        <textarea name="long_description" class="form-control" id="summernote" cols="30" rows="10">
                            @if(isset($upcoming_project))
                            {!!$upcoming_project->long_description!!}
                            @endif

                        </textarea>
                    </div>
                    <div class="mb-3">
                        <label for="logo" class="form-label">Thumbnail Image</label>
                        <input type="file" name="thumbnail" id="thumbnail_image" class="form-control" accept="image/*">
                    </div>
                    <div class="mb-3">
                        <div id="thumbnail_images" class="d-flex justify-content-center align-items-center"
                            style="border: 1px solid #ddd; padding: 10px; border-radius: 5px; width: 100%; height: 200px; background-color: #f8f9fa;">
                            @if($upcoming_project)
                            
                            <img src="{{asset('/')}}{{$upcoming_project->image}}" alt="" style="max-width:100%;max-height:100%;" alt="">
                            @else
                            @endif

                           


                        </div>
                    </div>
                    <div class="mb-3">
                     <button type="submit" class="btn btn-primary w-100">Edit</button>    
                    </div>                     
                </div>
            </form>
              </div>
         
    </div>

   
</div>
<script>
    $(document).ready(function() {
        $('#summernote').summernote({
        placeholder: 'Type Here',
        tabsize: 2,
        height: 120,
        toolbar: [
          ['style', ['style']],
          ['font', ['bold', 'underline', 'clear']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['table', ['table']],
          ['insert', ['link', 'picture', 'video']],
          ['view', ['fullscreen', 'codeview', 'help']]
        ]
      });
});
</script>
    <script>
        $(document).ready(function() {
            $('#thumbnail_image').change(function(event) {
                const imagePreview = $('#thumbnail_images');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

<script>
    $(document).ready(function() {
        $('#promo_2').change(function(event) {
            const imagePreview = $('#imagePreview_promo');
            imagePreview.empty();

            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = $('<img>').attr('src', e.target.result).css({
                        'max-width': '100%',
                        'max-height': '100%'
                    });
                    imagePreview.append(img);
                }
                reader.readAsDataURL(file);
            } else {
                imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
            }
        });
    });
</script>

<script>
    $(document).ready(function() {
        $('#promo_3').change(function(event) {
            const imagePreview = $('#imagePreview_promo3');
            imagePreview.empty();

            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = $('<img>').attr('src', e.target.result).css({
                        'max-width': '100%',
                        'max-height': '100%'
                    });
                    imagePreview.append(img);
                }
                reader.readAsDataURL(file);
            } else {
                imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
            }
        });
    });
</script>

    <script>
        $(document).ready(function() {
            $('#slider').change(function(event) {
                const imagePreview = $('#imagePreview_carousel');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    @if (session('success'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "success",
                title: "{{ session('success') }}"
            });
        </script>
    @endif

    @if (session('error'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "error",
                title: "{{ session('success') }}"
            });
        </script>
    @endif
@endsection
