@extends('Admin.layouts.app')
@section('content')
<div class="row">
    <div class="col-lg-4 col-sm-4">
        <div class="card">
            <div class="card-header">
                <h3>Top_header</h3>
            </div>
            <div class="card-body">
                <form action="{{route('admin.top_header_insert')}}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <label for="" class="form-label">Enter Email</label>
                        <input type="email" class="form-control" name="email" value="{{ $top_header ? $top_header->email : '' }}">
                    
                    </div>
                    <div class="mb-3">
                        <label for="" class="form-label">Phone Number</label>
                        <input type="text" class="form-control" name="phone" value="{{ $top_header ? $top_header->phone : '' }}">
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary">Insert Data</button>
                    </div>
                </form>
                

            </div>
        </div>

    </div>
    <div class="col-lg-4 col-sm-4">
        <div class="card">
            <div class="card-header">
                <h3>Logo</h3>
            </div>
            <div class="card-body">
                <form action="{{route('admin.logo')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="mb-3">
                        <label for="logo" class="form-label">Upload Logo</label>
                        <input type="file" name="logo" id="logo" class="form-control" accept="image/*">
                    </div>
                    <div class="mb-3">
                        <div id="imagePreview" class="d-flex justify-content-center align-items-center" style="border: 1px solid #ddd; padding: 10px; border-radius: 5px; width: 100%; height: 200px; background-color: #f8f9fa;">
                           
                            @if($logo)
                            <img src="{{asset('/')}}{{$logo->logo}}" style="max-width:100%;max-height:100%;" alt="">
                            
                            @else
                            <span class="text-muted">Image preview will appear here</span>
                            @endif
                           
                        </div>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary">Insert Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-4 col-sm-4">
        <div class="row">
            <div class="card">
                <div class="card-header">
                    <h3>Top Slider</h3>
                </div>
                <div class="card-body">
                    <form action="{{route('admin.carousel')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="mb-3">
                            <label for="carousel" class="form-label">Upload slider</label>
                            <input type="file" name="carousel" id="slider" class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3">
                            <div id="imagePreview_carousel" class="d-flex justify-content-center align-items-center" style="border: 1px solid #ddd; padding: 10px; border-radius: 5px; width: 100%; height: 200px; background-color: #f8f9fa;">
                               
                                <span class="text-muted">Image preview will appear here</span>
                               
                            </div>
                        </div>
                       
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary">Insert Data</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
       
        
    </div>

    <div class="col-lg-8 col-sm-6 pb-5 pt-5" >
        <div class="card">
            <div class="card-header">
                <h3>Top Slider</h3>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <tr class="text-center">
                        <th>Serial</th>
                        <th>Image</th>
                        <th>status</th>
                        <th>Action</th>
                    </tr>
                    @forelse($carousel as $key=>$top_slider)
                    <tr class="text-center">
                        <td>{{$key+1}}</td>
                        <td>
                            <img src="{{asset('/')}}{{$top_slider->image}}" style="height:50%;width:50%;" alt="">
                        </td>
                        <td>
                            @if($top_slider->status == 1)
                            <span class="badge badge-pill badge-success">Active</span>
                            @else
                            <span class="badge badge-pill badge-danger">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <div class="btn-group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                              Action
                            </button>
                            <div class="dropdown-menu">
                              <a class="dropdown-item" href="{{route('admin.carousel_inactive',$top_slider->id)}}">InActive</a>
                              <a class="dropdown-item" href="{{route('admin.carousel_active',$top_slider->id)}}">Active</a>
                              
                            </div>
                          </div>
                        </td>
                    </tr>
                    @empty
                    Sorry No Carousel
                @endforelse
                </table>
                
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('#logo').change(function(event) {
            const imagePreview = $('#imagePreview');
            imagePreview.empty();
    
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = $('<img>').attr('src', e.target.result).css({
                        'max-width': '100%',
                        'max-height': '100%'
                    });
                    imagePreview.append(img);
                }
                reader.readAsDataURL(file);
            } else {
                imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
            }
        });
    });
    </script>

<script>
    $(document).ready(function() {
        $('#slider').change(function(event) {
            const imagePreview = $('#imagePreview_carousel');
            imagePreview.empty();
    
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = $('<img>').attr('src', e.target.result).css({
                        'max-width': '100%',
                        'max-height': '100%'
                    });
                    imagePreview.append(img);
                }
                reader.readAsDataURL(file);
            } else {
                imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
            }
        });
    });
    </script>

@if(session('success'))
<script>
    const Toast = Swal.mixin({
toast: true,
position: "top-end",
showConfirmButton: false,
timer: 3000,
timerProgressBar: true,
didOpen: (toast) => {
toast.onmouseenter = Swal.stopTimer;
toast.onmouseleave = Swal.resumeTimer;
}
});
Toast.fire({
icon: "success",
title: "{{session('success')}}"
});
</script>
@endif

@if(session('error'))
<script>
    const Toast = Swal.mixin({
toast: true,
position: "top-end",
showConfirmButton: false,
timer: 3000,
timerProgressBar: true,
didOpen: (toast) => {
toast.onmouseenter = Swal.stopTimer;
toast.onmouseleave = Swal.resumeTimer;
}
});
Toast.fire({
icon: "error",
title: "{{session('success')}}"
});
</script>
@endif
    
@endsection