@extends('Admin.layouts.app')
@section('content')
    <div class="row">
        <div class="col-lg-6 col-sm-4 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3>
                        Icon Gallery
                    </h3>
                    @if ($errors->any())
                        {!! implode('', $errors->all('<div class="text-danger">:message</div>')) !!}
                    @endif
                </div>
                <div class="card-body">
                    <form action="{{route('admin.icon_post')}}" method="POST" enctype="multipart/form-data">
                        @csrf

                        
                        <div class="mb-3">
                            <label for="logo" class="form-label">Icon</label>
                            <input type="file" name="thumbnail" id="thumbnail_image" class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3">
                            <div id="thumbnail_images" class="d-flex justify-content-center align-items-center"
                                style="border: 1px solid #ddd; padding: 10px; border-radius: 5px; width: 100%; height: 200px; background-color: #f8f9fa;">
    
                               
    
    
                            </div>
                        </div>

                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary w-100">Insert</button>
                        </div>
                </div>
                </form>
            </div>

        </div>
    </div>
   <div class="container">
    <div class="row">
        <div class="col-lg-6 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3>Icons List</h3>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>Serial</th>
                            <th>Icon</th>
                            <th>Action</th>
                        </tr>
                        @forelse($icons as $key=>$icon)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>
                                <img src="{{asset('/')}}{{$icon->image}}" style="height:20%;width:20%;" alt="">
                            </td>
                            
                        </tr>
                        @empty
                        @endforelse
                    </table>
                </div>
            </div>
        </div>
        
    </div>
   </div>
    <style>
        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #333;
        }

        .you_tube {

            transition: transform 0.2s;
        }

        /* .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
        } */

        .container {
            padding-top: 20px;
        }

        .ratio {
            overflow: hidden;
        }

        .ratio iframe {
            border-radius: 0.25rem 0.25rem 0 0;
        }

        .card-body {
            background-color: #f8f9fa;
            border-top: 1px solid #e9ecef;
        }
    </style>




    <script>
        $(document).ready(function() {
            $('#summernote').summernote({
                placeholder: 'Type Here',
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#thumbnail_image').change(function(event) {
                const imagePreview = $('#thumbnail_images');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#promo_2').change(function(event) {
                const imagePreview = $('#imagePreview_promo');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#promo_3').change(function(event) {
                const imagePreview = $('#imagePreview_promo3');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#slider').change(function(event) {
                const imagePreview = $('#imagePreview_carousel');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    @if (session('success'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "success",
                title: "{{ session('success') }}"
            });
        </script>
    @endif

    @if (session('error'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "error",
                title: "{{ session('success') }}"
            });
        </script>
    @endif
@endsection
