<?php

namespace App\Http\Controllers;

use App\Models\Carousel;
use App\Models\Found_model;
use App\Models\Icon;
use App\Models\Image_gallery;
use App\Models\Information_store;
use App\Models\Logo;
use App\Models\on_going_project;
use App\Models\our_history;
use App\Models\Our_vision;
use App\Models\Promo_section;
use App\Models\Top_header;
use App\Models\Upcoming_project;
use App\Models\You_tube_model;


use Illuminate\Http\Request;

class WebsiteSettingController extends Controller
{
    //
    public function admin_top_header()
    {
        $top_header = Top_header::first();
        $logo = Logo::first();
        $carousel = Carousel::all();

        return view('Admin.Webiste_settings.top_header', [
            'top_header' => $top_header,
            'logo' => $logo,
            'carousel' => $carousel,
        ]);
    }
    public function admin_top_header_insert(Request $request)
    {
        $top_header = Top_header::first() ?? new Top_header();

        // Update the fields
        $top_header->email = $request->email;
        $top_header->phone = $request->phone;
        $top_header->save();

        return back()->with('success', "Successfully Inserted Data");
    }
    public function logo(Request $request)
    {
        // Validate the request
        $request->validate([
            'logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        // Retrieve the existing logo record or create a new one
        $logo = Logo::first() ?? new Logo();

        if ($request->hasFile('logo')) {
            // Get the file from the request
            $file = $request->file('logo');

            // Define a file name with a timestamp to avoid duplicate names
            $fileName = time() . '.' . $file->getClientOriginalExtension();

            // Move the file to the desired directory
            $file->move(public_path('website_settings/logo'), $fileName);

            // If there is an existing logo, delete the old file
            if ($logo->exists && $logo->logo) {
                $oldFilePath = public_path($logo->logo);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }
            }

            // Save the file path to the database
            $logo->logo = 'website_settings/logo/' . $fileName; // Adjust the path accordingly
            $logo->save();

            return back()->with('success', 'Logo uploaded successfully');
        }

        return back()->with('error', 'Please upload a logo');
    }
    public function admin_carousel(Request $request)
    {
        // return $request->all();
        // Validate the request
        $request->validate([
            'carousel' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        // Retrieve the existing logo record or create a new one
        $carousel =  new Carousel();

        if ($request->hasFile('carousel')) {
            // Get the file from the request
            $file = $request->file('carousel');

            // Define a file name with a timestamp to avoid duplicate names
            $fileName = time() . '.' . $file->getClientOriginalExtension();

            // Move the file to the desired directory
            $file->move(public_path('website_settings/carousel'), $fileName);



            // Save the file path to the database
            $carousel->image = 'website_settings/carousel/' . $fileName; // Adjust the path accordingly
            $carousel->status = 0;

            $carousel->save();

            return back()->with('success', 'Carousel uploaded successfully');
        }

        return back()->with('error', 'Please upload a logo');
    }
    public function carousel_inactive($id)
    {
        Carousel::find($id)->update([
            'status' => 0,
        ]);
        return back()->with('success', "Successfully Inactive");
    }
    public function carousel_active($id)
    {
        Carousel::find($id)->update([
            'status' => 1,
        ]);
        return back()->with('success', "Successfully Active");
    }
    public function promo_section()
    {
        $promo_section_1 = Promo_section::where('count', 1)->first();
        $promo_section_2 = Promo_section::where('count', 2)->first();
        $promo_section_3 = Promo_section::where('count', 3)->first();



        return view('Admin.Webiste_settings.promo_section', [
            'promo_section_1' => $promo_section_1,
            'promo_section_2' => $promo_section_2,
            'promo_section_3' => $promo_section_3,
        ]);
    }
    function promo_section_1(Request $request)
    {


        $promo_section_1 = Promo_section::where('count', 1)->first();
        if ($promo_section_1) {
            // Update both text and image if both are provided
            if ($request->short_text_1 && $request->hasFile('promo_1')) {
                // Delete the previous image
                $oldFilePath = public_path($promo_section_1->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                // Process the new image
                $file = $request->file('promo_1');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('website_settings/Promo_section'), $fileName);

                // Update both fields
                $promo_section_1->update([
                    'short_text' => $request->short_text_1,
                    'image' => 'website_settings/Promo_section/' . $fileName,
                ]);
            } elseif ($request->short_text_1) {
                // Update only text if provided
                $promo_section_1->update([
                    'short_text' => $request->short_text_1,
                ]);
            } elseif ($request->hasFile('promo_1')) {
                // Delete the previous image
                $oldFilePath = public_path($promo_section_1->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                // Process the new image
                $file = $request->file('promo_1');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('website_settings/Promo_section'), $fileName);

                // Update only image if provided
                $promo_section_1->update([
                    'image' => 'website_settings/Promo_section/' . $fileName,
                ]);
            }
        } else {
            $request->validate([
                'promo_1' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'short_text_1' => 'required|unique:promo_sections,short_text,',
            ]);
            $file = $request->file('promo_1');

            // Define a file name with a timestamp to avoid duplicate names
            $fileName = time() . '.' . $file->getClientOriginalExtension();

            // Move the file to the desired directory
            $file->move(public_path('website_settings/Promo_section'), $fileName);

            Promo_section::create([
                'count' => 1,
                'short_text' => $request->short_text_1,
                'image' => 'website_settings/Promo_section/' . $fileName,
            ]);
        }
        return back()->with('success', 'Success');
    }
    function promo_section_2(Request $request)
    {


        $promo_section_2 = Promo_section::where('count', 2)->first();
        if ($promo_section_2) {
            // Update both text and image if both are provided
            if ($request->short_text_2 && $request->hasFile('promo_1')) {
                // Delete the previous image
                $oldFilePath = public_path($promo_section_2->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                // Process the new image
                $file = $request->file('promo_1');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('website_settings/Promo_section'), $fileName);

                // Update both fields
                $promo_section_2->update([
                    'short_text' => $request->short_text_2,
                    'image' => 'website_settings/Promo_section/' . $fileName,
                ]);
            } elseif ($request->short_text_2) {
                // Update only text if provided
                $promo_section_2->update([
                    'short_text' => $request->short_text_2,
                ]);
            } elseif ($request->hasFile('promo_1')) {
                // Delete the previous image
                $oldFilePath = public_path($promo_section_2->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                // Process the new image
                $file = $request->file('promo_1');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('website_settings/Promo_section'), $fileName);

                // Update only image if provided
                $promo_section_2->update([
                    'image' => 'website_settings/Promo_section/' . $fileName,
                ]);
            }
        } else {
            $request->validate([
                'promo_1' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'short_text_2' => 'required|unique:promo_sections,short_text,',
            ]);
            $file = $request->file('promo_1');

            // Define a file name with a timestamp to avoid duplicate names
            $fileName = time() . '.' . $file->getClientOriginalExtension();

            // Move the file to the desired directory
            $file->move(public_path('website_settings/Promo_section'), $fileName);

            Promo_section::create([
                'count' => 2,
                'short_text' => $request->short_text_2,
                'image' => 'website_settings/Promo_section/' . $fileName,
            ]);
        }
        return back()->with('success', 'Success');
    }
    public function promo_section_3(Request $request)
    {
        $promo_section_3 = Promo_section::where('count', 3)->first();
        if ($promo_section_3) {
            // Update both text and image if both are provided
            if ($request->short_text_3 && $request->hasFile('promo_1')) {
                // Delete the previous image
                $oldFilePath = public_path($promo_section_3->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                // Process the new image
                $file = $request->file('promo_1');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('website_settings/Promo_section'), $fileName);

                // Update both fields
                $promo_section_3->update([
                    'short_text' => $request->short_text_3,
                    'image' => 'website_settings/Promo_section/' . $fileName,
                ]);
            } elseif ($request->short_text_2) {
                // Update only text if provided
                $promo_section_3->update([
                    'short_text' => $request->short_text_3,
                ]);
            } elseif ($request->hasFile('promo_1')) {
                // Delete the previous image
                $oldFilePath = public_path($promo_section_3->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                // Process the new image
                $file = $request->file('promo_1');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('website_settings/Promo_section'), $fileName);

                // Update only image if provided
                $promo_section_3->update([
                    'image' => 'website_settings/Promo_section/' . $fileName,
                ]);
            }
        } else {
            $request->validate([
                'promo_1' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'short_text_3' => 'required|unique:promo_sections,short_text,',
            ]);
            $file = $request->file('promo_1');

            // Define a file name with a timestamp to avoid duplicate names
            $fileName = time() . '.' . $file->getClientOriginalExtension();

            // Move the file to the desired directory
            $file->move(public_path('website_settings/Promo_section'), $fileName);

            Promo_section::create([
                'count' => 3,
                'short_text' => $request->short_text_3,
                'image' => 'website_settings/Promo_section/' . $fileName,
            ]);
        }
        return back()->with('success', 'Success');
    }
    public function who_we_are()
    {
        $founder_description = Found_model::first();
        $our_history = our_history::first();
        $our_vision = our_vision::first();

        return view('Admin.Webiste_settings.who_we_are',compact('founder_description','our_history','our_vision'));
    }
    public function founder_description(Request $request)
    {
        // return $request->all();
        $founder_description = Found_model::first();
        if ($founder_description) {
         

            if ( $request->hasFile('founder_picture')) {
                // Delete the previous image
                $oldFilePath = public_path($founder_description->founder_image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }
                $file = $request->file('founder_picture');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
   
               // Move the file to the desired directory
               $file->move(public_path('website_settings/Founder_image'), $fileName);
   
              
   
               $founder_description->update([
                   'founder_name' => $request->founder_name,
                   'founder_designation' => $request->founder_position,
                   'founder_speech' => $request->founder_speech,
                   'founder_image' => 'website_settings/Founder_image/' . $fileName,
               ]);
               return back()->with('success', 'successfully Changed');

            }else{
                $founder_description->update([
                    'founder_name' => $request->founder_name,
                    'founder_designation' => $request->founder_position,
                    'founder_speech' => $request->founder_speech,
                ]);
                return back()->with('success',"Successfully Changed");
            }
          
        } else {
            $request->validate([
                'founder_name' => 'required|string|max:255',
                'founder_position' => 'required|string|max:255',
                'founder_speech' => 'required|string',
                'founder_picture' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);

            $founder_description = new Found_model();
            $founder_description->founder_name = $request->founder_name;
            $founder_description->founder_designation = $request->founder_position;
            $founder_description->founder_speech = $request->founder_speech;
            if ($request->hasFile('founder_picture')) {
                $file = $request->file('founder_picture');
                $fileName = time() . '.' . $file->getClientOriginalExtension();

                // Move the file to the desired directory
                $file->move(public_path('website_settings/Founder_image'), $fileName);
                $founder_description->founder_image = 'website_settings/Founder_image/' . $fileName;
                $founder_description->save();
                return back()->with('success', 'successfully Inserted Data');
            }
        }
    }

    public function our_history(Request $request){
    //    return $request->all();
   
        $our_history = our_history::first();
        if ($our_history) {
         

            if ( $request->hasFile('history_picture')) {
                // Delete the previous image
                $oldFilePath = public_path($our_history->image);
                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }
                $file = $request->file('history_picture');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
   
               // Move the file to the desired directory
               $file->move(public_path('website_settings/company_history'), $fileName);
   
              
   
               $our_history->update([
                   'title' => $request->title,
                   'description' => $request->our_history,
                 
                   'image' => 'website_settings/company_history/' . $fileName,
               ]);
               return back()->with('success', 'successfully Changed');

            }else{
                $our_history->update([
                    'title' => $request->title,
                    'description' => $request->our_history,
                    
                ]);
                return back()->with('success',"Successfully Changed");
            }
          
        } else {
            $request->validate([
                'title' => 'required|string|max:255',
                'our_history' => 'required|string|',
                'history_picture' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);

            $our_history = new our_history();
            $our_history->title = $request->title;
            $our_history->description = $request->our_history;
          
            if ($request->hasFile('history_picture')) {
                $file = $request->file('history_picture');
                $fileName = time() . '.' . $file->getClientOriginalExtension();

                // Move the file to the desired directory
                $file->move(public_path('website_settings/company_history'), $fileName);
                $our_history->image = 'website_settings/company_history/' . $fileName;
                $our_history->save();
                return back()->with('success', 'successfully Inserted Data');
            }
        }
    }
    public function our_vision(Request $request){
            //   return $request->all();

              $our_vision = Our_vision::first();
              if ($our_vision) {
               
      
                  if ( $request->hasFile('our_vision_image')) {
                      // Delete the previous image
                      $oldFilePath = public_path($our_vision->image);
                      if (file_exists($oldFilePath)) {
                          unlink($oldFilePath);
                      }
                      $file = $request->file('our_vision_image');
                      $fileName = time() . '.' . $file->getClientOriginalExtension();
         
                     // Move the file to the desired directory
                     $file->move(public_path('website_settings/our_vision'), $fileName);
         
                    
         
                     $our_vision->update([
                         'title' => $request->titel,
                         'description' => $request->description,
                       
                         'image' => 'website_settings/our_vision/' . $fileName,
                     ]);
                     return back()->with('success', 'successfully Changed');
      
                  }else{
                      $our_vision->update([
                          'title' => $request->titel,
                          'description' => $request->description,
                          
                      ]);
                      return back()->with('success',"Successfully Changed");
                  }
                
              } else {
                // return $request->all();
                  $request->validate([
                      'titel' => 'required|string|max:255',
                      'description' => 'required|string|',
                      'our_vision_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
                  ]);
      
                  $our_vision = new Our_vision();
                  $our_vision->title = $request->titel;
                  $our_vision->description = $request->description;
                
                  if ($request->hasFile('our_vision_image')) {
                      $file = $request->file('our_vision_image');
                      $fileName = time() . '.' . $file->getClientOriginalExtension();
      
                      // Move the file to the desired directory
                      $file->move(public_path('website_settings/our_vision'), $fileName);
                      $our_vision->image = 'website_settings/our_vision/' . $fileName;
                      $our_vision->save();
                      return back()->with('success', 'successfully Inserted Data');
                  }
              }
    }
    public function on_going_project(){
        $ongoing_project= on_going_project::all();
        return view('Admin.Webiste_settings.ongoing',[
            'ongoing_project'=>$ongoing_project,
        ]);
    }
    public function on_going_project_store(Request $request){
        // return $request->all();
        $request->validate([
            'title' => 'required|string|',
            'short_description' => 'required|string|',
            'long_description' => 'required|',
            'thumbnail' => 'required|image|mimes:jpeg,png,jpg,gif|',
        ]);

      
            $file = $request->file('thumbnail');
            $fileName = time() . '.' . $file->getClientOriginalExtension();

            // Move the file to the desired directory
            $file->move(public_path('website_settings/on_going_project'), $fileName);
            
            
            on_going_project::create([
                'title'=>$request->title,
                'short_description'=>$request->short_description,
                'long_description'=>$request->long_description,
                'image'=>'website_settings/on_going_project/' . $fileName,
            ]);
            
            return back()->with('success', 'successfully Inserted Data');
        }
    
    public function ongoing_project_details($id){

       $on_going_project =  on_going_project::find($id);
         return view('Admin.Webiste_settings.ongoing_project_edit',[
            'on_going_project'=>$on_going_project,
         ]);
    }
    function edit_ongoing_project(Request $request,$id){
        $on_going_project = on_going_project::find($id);
    
        if (!$on_going_project) {
            return back()->with('error', 'Project not found');
        }
    
        // Update project details
        $on_going_project->title = $request->title;
        $on_going_project->short_description = $request->short_description;
        $on_going_project->long_description = $request->long_description;
    
        // Check if a new file is uploaded
        if ($request->hasFile('thumbnail')) {
            // Delete the previous image if it exists
            $oldFilePath = public_path($on_going_project->image);
            if (file_exists($oldFilePath)) {
                unlink($oldFilePath);
            }
    
            // Upload new file
            $file = $request->file('thumbnail');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('website_settings/on_going_project'), $fileName);
            $on_going_project->image = 'website_settings/on_going_project/' . $fileName;
        }
    
        // Save the updated project
        $on_going_project->save();
    
        return back()->with('success', 'Successfully Updated');
       
    }
    public function ongoing_project_first_page($id){
         $on_going_project = on_going_project::find($id)->update([
            'first_page'=>1,
        ]);
        return back()->with('success',"Successfully Added For The First Page");
       

    }
    public function ongoing_project_first_page_not_showing($id){
        $on_going_project = on_going_project::find($id)->update([
            'first_page'=>Null,
        ]);
        return back()->with('success',"Successfully Removed From  First Page");
       
    }
    public function ongoing_project_delete($id){
        $on_going_project =on_going_project::find($id);
        $oldFilePath = public_path($on_going_project->image);
        if (file_exists($oldFilePath)) {
            unlink($oldFilePath);
        }
        $on_going_project =on_going_project::find($id)->delete();

      
        return back()->with('success',"successfully Deleted");
    }
    public function upcoming_project(){
        $upcoming_project  = Upcoming_project::all();
        return view('Admin.Webiste_settings.upcoming_project',[
            'upcoming_project'=>$upcoming_project,
        ]);
    }
    public function upcoming_project_store(Request $request){
      // Validate the request
    $request->validate([
        'title' => 'required|string',
        'short_description' => 'required|string',
        'long_description' => 'required|string',
        'thumbnail' => 'required|image|mimes:jpeg,png,jpg,gif',
    ]);

    try {
        // Handle file upload
        $file = $request->file('thumbnail');

        // Check file size (e.g., 40MB)
        $maxFileSize = 40 * 1024 * 1024; // 40MB in bytes
        if ($file->getSize() > $maxFileSize) {
            return back()->with('error', 'The uploaded file exceeds the maximum allowed size of 40MB. Please reduce the file size or resolution.');
        }

        $fileName = time() . '.' . $file->getClientOriginalExtension();

        // Move the file to the desired directory
        $file->move(public_path('website_settings/upcoming_projects'), $fileName);

        // Insert data into the database
        $upcoming_project = Upcoming_project::create([
            'title' => $request->title,
            'short_description' => $request->short_description,
            'long_description' => $request->long_description,
            'image' => 'website_settings/upcoming_projects/' . $fileName,
        ]);

        // If successful, redirect back with success message
        return back()->with('success', 'Successfully inserted data');
    } catch (\Exception $e) {
        // If there's an error, redirect back with an error message
        return back()->with('error', 'Failed to insert data: ' . $e->getMessage());
    
    }
    }
    public function upcoming_project_single_show($id){
        
        $upcoming_project =  Upcoming_project::find($id);
        if($upcoming_project){
            return view('Admin.Webiste_settings.upcoming_project_edit',[
                'upcoming_project'=>$upcoming_project,
             ]);
        }else{
            return redirect()->route('admin.upcoming_project');
        }
        
    }
    public function upcoming_project_edit(Request $request,$id){
        $Upcoming_project = Upcoming_project::find($id);
    
        if (!$Upcoming_project) {
            return back()->with('error', 'Project not found');
        }
    
        // Update project details
        $Upcoming_project->title = $request->title;
        $Upcoming_project->short_description = $request->short_description;
        $Upcoming_project->long_description = $request->long_description;
    
        // Check if a new file is uploaded
        if ($request->hasFile('thumbnail')) {
            // Delete the previous image if it exists
            $oldFilePath = public_path($Upcoming_project->image);
            if (file_exists($oldFilePath)) {
                unlink($oldFilePath);
            }
    
            // Upload new file
            $file = $request->file('thumbnail');
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('website_settings/upcoming_projects'), $fileName);
            $Upcoming_project->image = 'website_settings/upcoming_projects/' . $fileName;
        }
    
        // Save the updated project
        $Upcoming_project->save();
    
        return back()->with('success', 'Successfully Updated');
    }
    public function upcoming_project_first_page_show($id){
        $Upcoming_project = Upcoming_project::find($id);
        if($Upcoming_project){
            $Upcoming_project->update([
                'first_page'=>1,
            ]);
            return back()->with('success',"Successfully Add for the First Page");
        }else{
            return redirect()->route('admin.upcoming_project');
        }
    }
    public function upcoming_project_first_page_not_show($id){
        $Upcoming_project = Upcoming_project::find($id);
        if($Upcoming_project){
            $Upcoming_project->update([
                'first_page'=>Null,
            ]);
            return back()->with('success',"Successfully Remove From the First Page");
        }else{
            return redirect()->route('admin.upcoming_project');
        }
    }
    public function upcoming_project_delete($id){
        
        $Upcoming_project =Upcoming_project::find($id);
        if($Upcoming_project){
            $oldFilePath = public_path($Upcoming_project->image);
            if (file_exists($oldFilePath)) {
                unlink($oldFilePath);
            }
            $Upcoming_project =Upcoming_project::find($id)->delete();
    
          
            return back()->with('success',"successfully Deleted");
        }else{
            return redirect()->route('admin.upcoming_project');

        }
     
    }
    public function you_tube_videos(){
        $you_tube = You_tube_model::all();
        return view('Admin.Webiste_settings.you_tube_add',[
            'you_tube'=>$you_tube,
        ]);
    }
    public function you_tube_store(Request $request){
        $request->validate([
            'title' => 'required|string',
            'link' => 'required|string',
          
        ]);
        
        You_tube_model::create([
            'title'=>$request->title,
            'link'=>$request->link,
        ]);
        return back()->With('success',"Successfully Created");

    
    }
    public function you_tube_edit(Request $request, $id){
        You_tube_model::find($id)->update([
            'title'=>$request->title,
            'link'=>$request->link,
        ]);
        return back()->with('success',"Successfully Updated");
    }
    public function you_tube_delete($id){
        You_tube_model::find($id)->delete();
        return back()->with('success',"Successfully Deleted You Tube Video");
    }
       public function image_gallery(){
        $image_gallery = Image_gallery::all();
        return view('Admin.Webiste_settings.image_gallery',[
            'image_gallery'=>$image_gallery,
        ]);
    }
    public function image_gallery_post(Request $request){
     // Validate the request
     $request->validate([
        'title' => 'required|string',
        'thumbnail' => 'required|image|mimes:jpeg,png,jpg,gif',
    ]);

    try {
        // Handle file upload
        $file = $request->file('thumbnail');

        $fileName = time() . '.' . $file->getClientOriginalExtension();

        // Move the file to the desired directory
        $file->move(public_path('website_settings/image_gallery'), $fileName);

        // Insert data into the database
        $upcoming_project = Image_gallery::create([
            'title' => $request->title,
            'image' => 'website_settings/image_gallery/' . $fileName,
        ]);

        // If successful, redirect back with success message
        return back()->with('success', 'Successfully inserted data');
    } catch (\Exception $e) {
        // If there's an error, redirect back with an error message
        return back()->with('error', 'Failed to insert data: ' . $e->getMessage());
    
    }
    }
    public function image_delete($id){
        Image_gallery::find($id)->delete();
        return back()->with('success',"Successfully Deleted");
    }
    public function add_icon(){
        $icons = Icon::all();
        return view('Admin.Webiste_settings.icon_page',[
            'icons'=>$icons,
        ]);
    }
    public function icon_post(Request $request){
          // Validate the request
     $request->validate([
        
        'thumbnail' => 'required|image|mimes:jpeg,png,jpg,gif,webp',
    ]);

    try {
        // Handle file upload
        $file = $request->file('thumbnail');

        $fileName = time() . '.' . $file->getClientOriginalExtension();

        // Move the file to the desired directory
        $file->move(public_path('website_settings/Icons'), $fileName);

        // Insert data into the database
        $upcoming_project = Icon::create([
            
            'image' => 'website_settings/Icons/' . $fileName,
        ]);

        // If successful, redirect back with success message
        return back()->with('success', 'Successfully inserted data');
    } catch (\Exception $e) {
        // If there's an error, redirect back with an error message
        return back()->with('error', 'Failed to insert data: ' . $e->getMessage());
    
    }
    }
    public function send_short_note(Request $request,$id){
        // return $request->all();
         Information_store::find($id)->update([
            'short_note'=>$request->add_short_note,
         ]);
         return back()->with('success',"Successfully Send the Short note");
    }
}
