<?php

namespace App\Http\Controllers;

use App\Models\Information_store;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PageController extends Controller
{
    //
    public function home_page(){
        return view('Frontend.homepage');
    }
    public function user_register(){
      
        return view('Frontend.user_register.user_register');
    }
    public function guest_user_profile_page(){
        return "hello";
    }
    public function user_form(){
        
        return view('Frontend.User_form.form');
    }
    function user_submit_information(Request $request){
        // dd($request->all()) ;
        $validatedData = $request->validate([
            'name' => 'required|string',
            'father_name' => 'required|string',
            'mother_name' => 'required|string',
            'gender' => 'required|string',
            'occupation' => 'required|string',
            'institute_name' => 'required|string',
            'present_address' => 'required|string',
            'permanent_address' => 'required|string',
            'nid_file' => 'required|file|mimes:pdf,jpeg,png,jpg,gif|max:10240', // Example validation for NID file (PDF)
            'office_id_file' => 'required|file|mimes:pdf,jpeg,png,jpg,gif|max:10240', // Example validation for Office ID file (PDF)
            'own_picture_file' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Example validation for picture file (Image)
        ]);
    
        // Handle file uploads and store them in the public folder
        if ($request->hasFile('nid_file')) {
         
             $nidFileName = $request->file('nid_file')->getClientOriginalName();
             
            // $request->file('nid_file')->storeAs('public/uploads', $nidFileName);
            $request->file('nid_file')->move(public_path('uploads/NID/'), $nidFileName);
        }
    
        if ($request->hasFile('office_id_file')) {
            $officeIdFileName = $request->file('office_id_file')->getClientOriginalName();
       
            $request->file('office_id_file')->move(public_path('uploads/OFFICE ID/'), $officeIdFileName);
            
         

        }
    
        if ($request->hasFile('own_picture_file')) {
            $pictureFileName = $request->file('own_picture_file')->getClientOriginalName();
  
            $request->file('own_picture_file')->move(public_path('uploads/OWN IMAGE/'), $pictureFileName);

        }
    
        $data = new Information_store();
        $data->user_id = Auth::user()->id;
        $data->name=$request->name;
        $data->father_name=$request->father_name;
        $data->mother_name = $request->mother_name;
        $data->gender = $request->gender;
        if($request->marriedCheckbox=="on"){
            $data->married = 'married';
            $data->spouse_name = $request->spouseName;
            if($request->childrenCheckbox == "on"){
                if($request->input('childName') == null){
                    $data->childrean = 'null';
                }else{
                    $childNames = $request->input('childName');
                    $data->childrean = implode(', ', array_filter($childNames));
                }
              
            }

        }
        $data->occupation = $request->occupation;
        $data->institute_name = $request->institute_name;
        $data->present_address = $request->present_address;
        $data->permanenet_address = $request->permanent_address;
        $data->Nid = $nidFileName;
        $data->Office_id = $officeIdFileName;
        $data->pictures = $pictureFileName;
        $data->status = 0;

        $data->save();
        return back()->with('success',"Successfully Inserted Your Data..Wait For The Approved");
        
      
    }
    function user_update_information(Request $request){
       
       
        $data = [
            'name' => $request->name,
            'father_name' => $request->father_name,
            'mother_name' => $request->mother_name,
            'gender' => $request->gender,
            'occupation' => $request->occupation,
            'institute_name' => $request->institute_name,
            'present_address' => $request->present_address,
            'permanenet_address' => $request->permanent_address,
        ];
        
        if ($request->marriedCheckbox == 'on') {
            
            $data['married'] = 'married';
            $data['spouse_name'] = $request->spouseName;
            if ($request->childrenCheckbox == 'on') {
                
                if ($request->input('childName') == null) {
                    $data['childrean'] = 'null';
                } elseif($request->input('childName')) {
                    $childNames = $request->input('childName');
                     $data['childrean'] = implode(', ', array_filter($childNames));
                }
            }else{
                if ($request->input('childName') == null) {
                    $data['childrean'] = 'null';
                } elseif($request->input('childName')) {
                    $childNames = $request->input('childName');
                     $data['childrean'] = implode(', ', array_filter($childNames));
                }
            }
        }
        
        $userId = Auth::user()->id;
        $information = Information_store::where('user_id', $userId)->first();
        
        if ($request->hasFile('nid_file')) {
            // Check if there is an existing file and delete it
            if ($information && !is_null($information->nid_file)) {
                $existingFilePath = public_path('uploads/NID/' . basename($information->nid_file));
        
                if (is_file($existingFilePath)) {
                    unlink($existingFilePath);
                }
            }
        
            // Store the new file
            $nidFileName = $request->file('nid_file')->getClientOriginalName();
            $request->file('nid_file')->move(public_path('uploads/NID/'), $nidFileName);
        
            // Update the data array with the new file name
            $data['Nid'] = $nidFileName;
        }

        if ($request->hasFile('office_id_file')) {
            
            if ($information && !is_null($information->Office_id)) {
                $existingOffice_id = public_path('uploads/OFFICE ID/' . basename($information->Office_id));
        
                if (is_file($existingOffice_id)) {
                    unlink($existingOffice_id);
                }
            }
        
            // Store the new file
            $office = $request->file('office_id_file')->getClientOriginalName();
            $request->file('office_id_file')->move(public_path('uploads/OFFICE ID/'), $office);
        
            // Update the data array with the new file name
            $data['Office_id'] = $office;
        }


        if ($request->hasFile('own_picture_file')) {
               
            if ($information && !is_null($information->pictures)) {
                $existing_own_image = public_path('uploads/OWN IMAGE/' . basename($information->pictures));
        
                if (is_file($existing_own_image)) {
                    unlink($existing_own_image);
                }
            }
        
            // Store the new file
            $own_image = $request->file('own_picture_file')->getClientOriginalName();
            $request->file('own_picture_file')->move(public_path('uploads/OWN IMAGE/'), $own_image);
        
            // Update the data array with the new file name
            $data['pictures'] = $own_image;

        }
        
        // Update the information in the database
        Information_store::where('user_id', $userId)->update($data);
        return back()->with('success',"Successfully changed");
    }
    public function galleries(){
        return view('Frontend_1.gallery.gallery');
    }
    public function blog_list(){
        return view('Frontend_1.blogs.blog_list');
    }
    public function user_you_tube_list(){
        return view('Frontend_1.you_tube.you_tube_list');
    }
    public function user_profile(){
        return view('Frontend_1.profile.user_profile');
    }
    public function user_profile_edit(Request $request){
        $request->validate([
            'user_name'=>'required',
            'email'=>'required|unique:users,email',
            'password'=>'required',
        ]);
        User::find(Auth::user()->id)->update([
            'name'=>$request->user_name,
            'email'=>$request->email,
            'password'=>$request->password
        ]);
        return back()->with('success',"Successfully Updated");
        // return $request->all();
    }
}
