<?php $__env->startSection('title', translate('offline_Payment_Method')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/3rd-party.png')); ?>" alt="">
                <?php echo e(translate('3rd_party')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
        <?php echo $__env->make('admin-views.business-settings.third-party-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Inlile Menu -->

        <nav>
            <div class="nav nav-tabs mb-3 border-0" role="tablist">
              <a class="nav-link <?php echo e(!request()->has('status') ? 'active':''); ?>" href="<?php echo e(route('admin.business-settings.payment-method.offline')); ?>"><?php echo e(translate('all')); ?></a>
              <a class="nav-link <?php echo e(request('status') == 'active' ? 'active':''); ?>" href="<?php echo e(route('admin.business-settings.payment-method.offline')); ?>?status=active"><?php echo e(translate('active')); ?></a>
              <a class="nav-link <?php echo e(request('status') == 'inactive' ? 'active':''); ?>" href="<?php echo e(route('admin.business-settings.payment-method.offline')); ?>?status=inactive"><?php echo e(translate('inactive')); ?></a>
            </div>
        </nav>

        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-all" role="tabpanel" aria-labelledby="nav-all-tab">
                <div class="card">
                    <!-- Data Table Top -->
                    <div class="px-3 py-4">
                        <div class="row g-2 flex-grow-1">
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <!-- Search -->
                                <form action="<?php echo e(route('admin.business-settings.payment-method.offline')); ?>" method="GET">
                                    <div class="input-group input-group-custom input-group-merge">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control" placeholder="<?php echo e(translate('search_by_name')); ?>" aria-label="Search by ID or name" value="<?php echo e(request('search')); ?>" required="">
                                        <button type="submit" class="btn btn--primary input-group-text"><?php echo e(translate('search')); ?></button>
                                    </div>
                                </form>
                                <!-- End Search -->
                            </div>
                            <div class="col-sm-4 col-md-6 col-lg-8 d-flex justify-content-end">
                                <a href="<?php echo e(route('admin.business-settings.payment-method.offline.new')); ?>" class="btn btn--primary"><i class="tio-add"></i> <?php echo e(translate('add_New_Method')); ?></a>
                            </div>
                        </div>
                        <!-- End Row -->
                    </div>
                    <!-- End Data Table Top -->

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th><?php echo e(translate('SL')); ?></th>
                                        <th><?php echo e(translate('payment_Method_Name')); ?></th>
                                        <th><?php echo e(translate('payment_Info')); ?></th>
                                        <th><?php echo e(translate('required_Info_From_Customer')); ?></th>
                                        <th class="text-center"><?php echo e(translate('status')); ?></th>
                                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($method->method_name); ?></td>
                                            <td>
                                                <div class="d-flex flex-column gap-1">
                                                    <?php $__currentLoopData = $method->method_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div><?php echo e(ucwords(str_replace('_',' ',$item['input_name']))); ?> : <?php echo e($item['input_data']); ?></div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-column gap-1">
                                                    <?php $__currentLoopData = $method->method_informations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div>
                                                        <?php echo e(ucwords(str_replace('_',' ',$item['customer_input']))); ?>

                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </td>
                                            <td>

                                                <form action="<?php echo e(route('admin.business-settings.payment-method.offline.status')); ?>" method="post" id="method_status<?php echo e($method['id']); ?>_form" class="method_status_form">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="id" value="<?php echo e($method['id']); ?>">
                                                    <label class="switcher mx-auto">
                                                        <input type="checkbox" class="switcher_input" id="method_status<?php echo e($method['id']); ?>" name="status" <?php echo e($method->status == 1 ? 'checked':''); ?> onclick="toogleStatusModal(event,'method_status<?php echo e($method['id']); ?>','offline-payment-on.png','offline-payment-off.png','<?php echo e(translate('Want_to_Turn_ON_Offline_Payment_Methods')); ?>','<?php echo e(translate('Want_to_Turn_OFF_Offline_Payment_Methods')); ?>',`<p><?php echo e(translate('if_enabled_customers_can_pay_through_different_payment_methods_outside_your_system')); ?></p>`,`<p><?php echo e(translate('if_disabled_customers_can_only_pay_through_the_system_supported_payment_methods')); ?></p>`)">
                                                        <span class="switcher_control"></span>
                                                    </label>
                                                </form>

                                            </td>
                                            <td>
                                                <div class="d-flex justify-content-center gap-2">
                                                    <a class="btn btn-outline-info btn-sm square-btn" title="Edit" href="<?php echo e(route('admin.business-settings.payment-method.offline.edit', ['id'=>$method->id])); ?>">
                                                        <i class="tio-edit"></i>
                                                    </a>
                                                    <button class="btn btn-outline-danger btn-sm delete square-btn" title="Delete" onclick="form_alert('delete-method_name-<?php echo e($method->id); ?>', '<?php echo e(translate('Want_to_delete_this_item')); ?> ?')">
                                                        <i class="tio-delete"></i>
                                                    </button>

                                                    <form action="<?php echo e(route('admin.business-settings.payment-method.offline.delete')); ?>" method="post" id="delete-method_name-<?php echo e($method->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" value="<?php echo e($method->id); ?>" name="id" required>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <?php if($methods->count() > 0): ?>
                                <div class="p-3 d-flex justify-content-end">
                                    <?php
                                        if (request()->has('status')) {
                                            $paginationLinks = $methods->links();
                                            $modifiedLinks = preg_replace('/href="([^"]*)"/', 'href="$1&status='.request('status').'"', $paginationLinks);
                                        } else {
                                            $modifiedLinks = $methods->links();
                                        }
                                    ?>

                                    <?php echo $modifiedLinks; ?>

                                </div>
                            <?php else: ?>
                                <div class="text-center p-4">
                                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                    <p class="mb-0"><?php echo e(translate('no_data_to_show')); ?></p>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $('.method_status_form').on('submit', function(event){
        event.preventDefault();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
            }
        });
        $.ajax({
            url: "<?php echo e(route('admin.business-settings.payment-method.offline.status')); ?>",
            method: 'POST',
            data: $(this).serialize(),
            success: function (data) {
                if(data.success_status == 1) {
                    toastr.success(data.message);
                }else if(data.success_status == 0) {
                    toastr.error(data.message);
                }
                setTimeout(function(){
                    location.reload();
                }, 1000);
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/business-settings/payment-method/offline-payment/index.blade.php ENDPATH**/ ?>