<?php $__env->startSection('title', translate('currency')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php ($currency_model=\App\CPU\Helpers::get_business_settings('currency_model')); ?>
    <?php ($default=\App\CPU\Helpers::get_business_settings('system_default_currency')); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/system-setting.png')); ?>" alt="">
                <?php echo e(translate('system_Setup')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inline Menu -->
        <?php echo $__env->make('admin-views.business-settings.system-settings-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Inline Menu -->


        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 d-flex align-items-center gap-2">
                    <img width="20 " src="<?php echo e(asset('/public/assets/back-end/img/currency-1.png')); ?>" alt="">
                    <?php echo e(translate('default-currency_setup')); ?>

                </h5>
            </div>
            <div class="card-body">
                <form class="form-inline_ text-start" action="<?php echo e(route('admin.currency.system-currency-update')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php ($default=\App\Model\BusinessSetting::where('type', 'system_default_currency')->first()); ?>
                    <div class="form-group">
                        <label for="currency_id" class="title-color"><?php echo e(translate('currency')); ?></label>
                        <select class="form-control js-select2-custom" name="currency_id">
                            <?php $__currentLoopData = App\Model\Currency::where('status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option
                                    value="<?php echo e($currency->id); ?>" <?php echo e($default->value == $currency->id?'selected':''); ?> >
                                    <?php echo e($currency->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="d-flex justify-content-end flex-wrap mt-3">
                        <button type="submit" class="btn btn--primary px-5"><?php echo e(translate('save')); ?></button>
                    </div>
                </form>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0 d-flex align-items-center gap-2">
                    <img width="18" src="<?php echo e(asset('/public/assets/back-end/img/currency-1.png')); ?>" alt="">
                    <?php echo e(translate('add_currency')); ?>

                </h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.currency.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="">
                        <div class="row">
                            <div class="col-sm-6 col-lg-4 col-xl-3">
                                <div class="form-group">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <label for="name" class="title-color mb-0"><?php echo e(translate('currency_name')); ?></label>
                                        <i class="tio-info-outined" data-toggle="tooltip" title="<?php echo e(translate('add_the_name_of_the_currency_you_want_to_add')); ?>"></i>
                                    </div>
                                    <input type="text" name="name" class="form-control" id="name" placeholder="<?php echo e(translate('ex')); ?> : United States Dollar" required>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-4 col-xl-3">
                                <div class="form-group">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <label for="symbol" class="title-color mb-0"><?php echo e(translate('currency_symbol')); ?></label>
                                        <i class="tio-info-outined" data-toggle="tooltip" title="<?php echo e(translate('add_the_symbol_of_the_currency_you_want_to_add')); ?>"></i>
                                    </div>
                                    <input type="text" name="symbol" class="form-control" id="symbol" placeholder="<?php echo e(translate('ex')); ?> : $" required>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-4 col-xl-3">
                                <div class="form-group">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <label for="symbol" class="title-color mb-0"><?php echo e(translate('currency_code')); ?></label>
                                        <i class="tio-info-outined" data-toggle="tooltip" title="<?php echo e(translate('add_the_code_of_the_currency_you_want_to_add')); ?>"></i>
                                    </div>
                                    <input type="text" name="code" class="form-control" id="code" placeholder="<?php echo e(translate('ex')); ?> : USD" required>
                                </div>
                            </div>
                            <?php if($currency_model=='multi_currency'): ?>
                            <div class="col-sm-6 col-lg-4 col-xl-3">
                                <div class="form-group">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <label for="exchange_rate" class="title-color mb-0"><?php echo e(translate('exchange_rate')); ?></label>
                                        <i class="tio-info-outined" data-toggle="tooltip" title="<?php echo e(translate('based_on_your_region_set_the_exchange_rate_of_the_currency_you_want_to_add')); ?>"></i>
                                    </div>
                                    <input type="number" min="0" max="1000000" name="exchange_rate" step="0.00000001" class="form-control" id="exchange_rate" placeholder="<?php echo e(translate('ex')); ?> : 120" required>
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-3">
                                    <button type="reset" class="btn btn-secondary px-5"><?php echo e(translate('reset')); ?></button>
                                    <button type="submit" id="add" class="btn btn--primary px-5"><?php echo e(translate('submit')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <div class="mt-4">
                    <div class="table-responsive">
                        <table
                            class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table text-start">
                            <thead class="thead-light thead-50 text-capitalize">
                                <tr>
                                    <th><?php echo e(translate('SL')); ?></th>
                                    <th><?php echo e(translate('currency_name')); ?></th>
                                    <th><?php echo e(translate('currency_symbol')); ?></th>
                                    <th><?php echo e(translate('currency_code')); ?></th>
                                    <?php if($currency_model=='multi_currency'): ?>
                                        <th><?php echo e(translate('exchange_rate')); ?>

                                            (1 <?php echo e(App\Model\Currency::where('id', $default->value)->first()->code); ?>= ?)
                                        </th>
                                    <?php endif; ?>
                                    <th><?php echo e(translate('status')); ?></th>
                                    <th class="text-center"><?php echo e(translate('action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($currencies->firstitem()+ $key); ?></td>
                                    <td><?php echo e($data->name); ?></td>
                                    <td><?php echo e($data->symbol); ?></td>
                                    <td><?php echo e($data->code); ?></td>
                                    <?php if($currency_model=='multi_currency'): ?>
                                        <td><?php echo e($data->exchange_rate); ?></td>
                                    <?php endif; ?>
                                    <td>
                                        <?php if($default['value']!=$data->id): ?>

                                            <form action="<?php echo e(route('admin.currency.status')); ?>" method="post" id="currency_status<?php echo e($data['id']); ?>_form" class="currency_status_form">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($data['id']); ?>">
                                                <label class="switcher">
                                                    <input type="checkbox" class="switcher_input" id="currency_status<?php echo e($data['id']); ?>" name="status" class="toggle-switch-input" <?php echo e($data->status?'checked':''); ?> onclick="toogleStatusModal(event,'currency_status<?php echo e($data['id']); ?>','currency-on.png','currency-off.png','<?php echo e(translate('Want_to_Turn_ON_Currency_Status')); ?>','<?php echo e(translate('Want_to_Turn_OFF_Currency_Status')); ?>',`<p><?php echo e(translate('if_enabled_this_currency_will_be_available_throughout_the_entire_system')); ?></p>`,`<p><?php echo e(translate('if_disabled_this_currency_will_be_hidden_from_the_entire_system')); ?></p>`)">
                                                    <span class="switcher_control"></span>
                                                </label>
                                            </form>

                                        <?php else: ?>
                                            <label class="badge badge-primary-light"><?php echo e(translate('default')); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-10 justify-content-center">
                                            <?php if($data->code!='USD'): ?>
                                                <a  title="<?php echo e(translate('edit')); ?>"
                                                    type="button" class="btn btn-outline--primary btn-sm btn-xs edit"
                                                    href="<?php echo e(route('admin.currency.edit',[$data->id])); ?>">
                                                    <i class="tio-edit"></i>
                                                </a>
                                                <?php if($default['value']!=$data->id): ?>
                                                <a  title="<?php echo e(translate('delete')); ?>"
                                                    type="button" class="btn btn-outline-danger btn-sm btn-xs delete"
                                                    id="<?php echo e($data->id); ?>"
                                                    >
                                                    <i class="tio-delete"></i>
                                                </a>
                                                <?php else: ?>
                                                    <a href="javascript:" title="<?php echo e(translate('delete')); ?>"
                                                        type="button" class="btn btn-outline-danger btn-sm btn-xs"
                                                        onclick="default_currency_delete_alert()"
                                                        >
                                                        <i class="tio-delete"></i>
                                                    </a>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <button title="<?php echo e(translate('edit')); ?>"
                                                        class="btn btn-outline--primary btn-sm btn-xs edit" disabled>
                                                    <i class="tio-edit"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($currencies->links()); ?>

                        </div>
                    </div>

                    <?php if(count($currencies)==0): ?>
                        <div class="text-center p-4">
                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                    alt="Image Description">
                            <p class="mb-0"><?php echo e(translate('no_data_to_show')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level custom scripts -->
    <script src="<?php echo e(asset('public/assets/select2/js/select2.min.js')); ?>"></script>
    <script>
        $(".js-example-theme-single").select2({
            theme: "classic"
        });

        $(".js-example-responsive").select2({
            width: 'resolve'
        });
    </script>

    <script>
        $('.currency_status_form').on('submit', function(event){
            event.preventDefault();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.currency.status')); ?>",
                method: 'POST',
                data: $(this).serialize(),
                success: function (response) {
                    if (response.status === 1) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                }
            });
        });
    </script>

    <script>
        $(document).on('click', '.delete', function () {
        var id = $(this).attr("id");
        Swal.fire({
            title: "<?php echo e(translate('are_you_sure_delete_this')); ?> ?",
            text: "<?php echo e(translate('you_will_not_be_able_to_revert_this')); ?>!",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: "<?php echo e(translate('yes_delete_it')); ?>!",
            cancelButtonText: '<?php echo e(translate("cancel")); ?>',
            type: 'warning',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('admin.currency.delete')); ?>",
                    method: 'POST',
                    data: {id: id},
                    success: function (data) {

                        if(data.status ==1){
                            toastr.success("<?php echo e(translate('currency_removed_successfully')); ?> !");
                            location.reload();
                        }else{
                            toastr.warning("<?php echo e(translate('this_Currency_cannot_be_removed_due_to_payment_gateway_dependency')); ?> !");
                            location.reload();
                        }
                    }
                });
            }
        })
    });
    </script>
    <script>
        function default_currency_delete_alert()
        {
            toastr.warning('<?php echo e(translate('default currency can not be deleted!to delete change the default currency first!')); ?>');
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/currency/view.blade.php ENDPATH**/ ?>