<!-- Header -->
<div class="card-header">
    <h4 class="d-flex align-items-center text-capitalize gap-10 mb-0">
        <img src="<?php echo e(asset('/public/assets/back-end/img/top-customers.png')); ?>" alt="">
        <?php echo e(translate('top_Delivery_Man')); ?>

    </h4>
</div>
<!-- End Header -->

<!-- Body -->
<div class="card-body">
    <?php if($top_deliveryman): ?>
        <div class="grid-card-wrap">
            <?php $__currentLoopData = $top_deliveryman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($item->delivery_man)): ?>
                    <div class="cursor-pointer" onclick="location.href='<?php echo e(route('seller.delivery-man.earning-statement', ['id' => $item->delivery_man['id']])); ?>'">
                        <div class="grid-card basic-box-shadow">
                            <div class="text-center">
                                <img class="avatar rounded-circle avatar-lg"
                                     onclick="location.href='<?php echo e(route('seller.delivery-man.earning-statement',[$item['delivery_man_id']])); ?>'"
                                     onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img1.jpg')); ?>'"
                                     src="<?php echo e(asset('storage/app/public/delivery-man/'.$item->delivery_man->image??'')); ?>">
                            </div>

                            <h5 class="mb-0">
                                <?php echo e(Str::limit($item->delivery_man['f_name'], 15)); ?>

                            </h5>

                            <div class="orders-count d-flex gap-1">
                                <div><?php echo e(translate('delivered')); ?> : </div>
                                <div><?php echo e($item['count']); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="text-center">
            <p class="text-muted"><?php echo e(translate('no_Top_Selling_Products')); ?></p>
            <img class="w-75" src="<?php echo e(asset('/public/assets/back-end/img/no-data.png')); ?>" alt="">
        </div>
    <?php endif; ?>
</div>
<!-- End Body -->
<?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/seller-views/partials/_top-delivery-man.blade.php ENDPATH**/ ?>