<button type="button" class="close" data-dismiss="modal" aria-label="Close">
    <i class="tio-clear"></i>
</button>
<div class="coupon__details">
    <div class="coupon__details-left">
        <div class="text-center">
            <h6 class="title" id="title"><?php echo e($coupon->title); ?></h6>
            <h6 class="subtitle"><?php echo e(translate('code')); ?> : <span id="coupon_code"><?php echo e($coupon->code); ?></span></h6>
            <div class="text-capitalize">
                <span><?php echo e(translate(str_replace('_',' ',$coupon->coupon_type))); ?></span>
            </div>
        </div>
        <div class="coupon-info">
            <div class="coupon-info-item">
                <span><?php echo e(translate('minimum_purchase')); ?> :</span>
                <strong id="min_purchase"><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($coupon->min_purchase))); ?></strong>
            </div>
            <?php if($coupon->coupon_type != 'free_delivery' && $coupon->discount_type == 'percentage'): ?>
            <div class="coupon-info-item" id="max_discount_modal_div">
                <span><?php echo e(translate('maximum_discount')); ?> : </span>
                <strong id="max_discount"><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($coupon->max_discount))); ?></strong>
            </div>
            <?php endif; ?>
            <div class="coupon-info-item">
                <span><?php echo e(translate('start_date')); ?> : </span>
                <span id="start_date"><?php echo e(\Carbon\Carbon::parse($coupon->start_date)->format('dS M Y')); ?></span>
            </div>
            <div class="coupon-info-item">
                <span><?php echo e(translate('expire_date')); ?> : </span>
                <span id="expire_date"><?php echo e(\Carbon\Carbon::parse($coupon->expire_date)->format('dS M Y')); ?></span>
            </div>
            <div class="coupon-info-item">
                <span><?php echo e(translate('discount_bearer')); ?> : </span>
                <span id="expire_date"><?php echo e($coupon->coupon_bearer == 'inhouse' ? translate('admin') : translate($coupon->coupon_bearer)); ?></span>
            </div>
        </div>
    </div>
    <div class="coupon__details-right">
        <div class="coupon">
            <?php if($coupon->coupon_type == 'free_delivery'): ?>
                <img src="<?php echo e(asset('public/assets/back-end/img/free-delivery.png')); ?>" alt="Free delivery" width="100">
            <?php else: ?>
                <div class="d-flex">
                    <h4 id="discount">
                        <?php echo e($coupon->discount_type=='amount'?\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($coupon->discount)):$coupon->discount.'%'); ?>

                    </h4>
                </div>

                <span><?php echo e(translate('off')); ?></span>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/coupon/details-quick-view.blade.php ENDPATH**/ ?>