<?php $__env->startSection('title',translate('reund_requests')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">

    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img src="<?php echo e(asset('/public/assets/back-end/img/refund-request.png')); ?>" alt="">
            <?php echo e(translate('pending_Refund_Requests')); ?>

            <span class="badge badge-soft-dark radius-50"><?php echo e($refund_list->total()); ?></span>
        </h2>
    </div>
    <!-- End Page Title -->

    <!-- Card -->
    <div class="card">
        <!-- Header -->
        <div class="p-3">
            <div class="row justify-content-between align-items-center">
                <div class="col-12 col-md-4">
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <!-- Search -->
                        <div class="input-group input-group-merge input-group-custom">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="tio-search"></i>
                                </div>
                            </div>
                            <input id="datatableSearch_" type="search" name="search" class="form-control"
                                    placeholder="<?php echo e(translate('search_by_order_id_or_refund_id')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>">
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('search')); ?></button>
                        </div>
                        <!-- End Search -->
                    </form>
                </div>
                <div class="col-12 mt-3 col-md-8">

                    <div class="d-flex gap-3 justify-content-md-end">
                        <div class="dropdown text-nowrap">
                            <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                <i class="tio-download-to"></i>
                                <?php echo e(translate('export')); ?>

                                <i class="tio-chevron-down"></i>
                            </button>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a type="submit" class="dropdown-item d-flex align-items-center gap-2 " href="<?php echo e(route('admin.refund-section.refund.export',['status'=>request('status'),'search'=>$search])); ?>">
                                        <img width="14" src="<?php echo e(asset('/public/assets/back-end/img/excel.png')); ?>" alt="">
                                        <?php echo e(translate('excel')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                        <select name="" id="" class="form-control w-auto" onchange="filter_order(this.value)">
                            <option value="all" <?php echo e(session()->has('show_inhouse_and_seller_orders') && session('show_inhouse_and_seller_orders') == 1 ?'selected':''); ?>><?php echo e(translate('all')); ?></option>
                            <option value="inhouse" <?php echo e(session()->has('show_inhouse_orders') && session('show_inhouse_orders')==1?'selected':''); ?>><?php echo e(translate('inhouse_Requests')); ?></option>
                            <option value="seller" <?php echo e(session()->has('show_seller_orders') && session('show_seller_orders') == 1?'selected':''); ?>><?php echo e(translate('seller_Requests')); ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <!-- End Row -->
        </div>
        <!-- End Header -->

        <!-- Table -->
        <div class="table-responsive datatable-custom">
            <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100"
                    style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>">
                <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(translate('SL')); ?></th>
                        <th><?php echo e(translate('order_id')); ?> </th>
                        <th><?php echo e(translate('product_info')); ?></th>
                        <th><?php echo e(translate('customer_info')); ?></th>
                        <th class="text-end"><?php echo e(translate('total_amount')); ?></th>
                        <th><?php echo e(translate('refund_status')); ?></th>
                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                    </tr>
                </thead>

                <tbody>
                <?php $__currentLoopData = $refund_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$refund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($refund_list->firstItem()+$key); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.orders.details',['id'=>$refund->order_id])); ?>" class="title-color hover-c1">
                                <?php echo e($refund->order_id); ?>

                            </a>
                        </td>
                        <td>
                            <?php if($refund->product!=null): ?>


                                <div class="d-flex flex-wrap gap-2">
                                    <a href="<?php echo e(route('admin.product.view',[$refund->product->id])); ?>">
                                        <img onerror="this.src='<?php echo e(asset('/public/assets/back-end/img/brand-logo.png')); ?>'"
                                            src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($refund->product->thumbnail); ?>"
                                             class="avatar border" alt="">
                                    </a>
                                    <div class="d-flex flex-column gap-1">
                                        <a href="<?php echo e(route('admin.product.view',[$refund->product->id])); ?>" class="title-color font-weight-bold hover-c1">
                                            <?php echo e(\Illuminate\Support\Str::limit($refund->product->name,35)); ?>

                                        </a>
                                        <span class="fz-12"><?php echo e(translate('QTY')); ?> : <?php echo e($refund->order_details->qty); ?></span>
                                    </div>
                                </div>
                            <?php else: ?>
                                <?php echo e(translate('product_name_not_found')); ?>

                            <?php endif; ?>

                        </td>
                        <td>
                            <?php if($refund->customer !=null): ?>
                                <div class="d-flex flex-column gap-1">
                                    <a href="<?php echo e(route('admin.customer.view',[$refund->customer->id])); ?>" class="title-color font-weight-bold hover-c1">
                                        <?php echo e($refund->customer->f_name. ' '.$refund->customer->l_name); ?>

                                    </a>
                                    <a href="tel:<?php echo e($refund->customer->phone); ?>" class="title-color hover-c1 fz-12"><?php echo e($refund->customer->phone); ?></a>
                                </div>
                            <?php else: ?>
                                <a href="#" class="title-color hover-c1">
                                    <?php echo e(translate('customer_not_found')); ?>

                                </a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex flex-column gap-1 text-end">
                                <div><?php echo e(\App\CPU\Helpers::currency_converter($refund->amount)); ?></div>
                            </div>
                        </td>
                        <td>
                            <div class="d-inline-flex flex-column gap-1">
                                <?php if($refund->status=='pending'): ?>
                                    <span class="badge badge-soft--primary"><?php echo e(translate($refund->status)); ?></span>
                                <?php elseif($refund->status=='approved'): ?>
                                    <span class="badge badge-soft-success"><?php echo e(translate($refund->status)); ?></span>
                                <?php elseif($refund->status=='rejected'): ?>
                                    <span class="badge badge-soft-danger"><?php echo e(translate($refund->status)); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-soft-warning"><?php echo e(translate($refund->status)); ?></span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex justify-content-center">
                                <a  class="btn btn-outline--primary btn-sm"
                                    title="<?php echo e(translate('view')); ?>"
                                    href="<?php echo e(route('admin.refund-section.refund.details',['id'=>$refund['id']])); ?>">
                                    <i class="tio-invisible"></i>
                                </a>
                            </div>
                        </td>
                    </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- End Table -->

        <div class="table-responsive mt-4">
            <div class="px-4 d-flex justify-content-lg-end">
                <!-- Pagination -->
                <?php echo $refund_list->links(); ?>

            </div>
        </div>

        <?php if(count($refund_list)==0): ?>
            <div class="text-center p-4">
                <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                <p class="mb-0"><?php echo e(translate('no_data_to_show')); ?></p>
            </div>
        <?php endif; ?>
        <!-- End Footer -->
    </div>
    <!-- End Card -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        function filter_order(type = null) {
            $.get({
                url: '<?php echo e(route('admin.refund-section.refund.inhouse-order-filter')); ?>'+ (type ? '?type='+type : ''),
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $('#loading').fadeIn();
                },
                success: function (data) {
                    toastr.success('<?php echo e(translate("order_filter_success")); ?>');
                    location.reload();
                },
                complete: function () {
                    $('#loading').fadeOut();
                },
            });
        };
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/refund/list.blade.php ENDPATH**/ ?>